function getOriginalCodeAndFiller(address)
  local original,filler

  if type(address)~='number' then
    address=getAddressSafe(address)
  end

  if address==nil then
    return nil, 'invalid address'
  end

  local sl=createStringList()
  local d=createDisassembler()
  local size=0
  while size<5 do
    d.disassemble(address)
    local ldd=d.LastDisassembleData
    local inst=ldd.opcode..' '..ldd.parameters
    sl.add(inst)
    size=size+#ldd.bytes
    address=address+#ldd.bytes
  end

  original=sl.Text
  if size-5>0 then
    filler=string.format("nop %x", size-5)
  else
    filler=''
  end

  sl.destroy()
  d.destroy()
  return original,filler
end


function hookSpeedFunctions()
  if speedhack and speedhack.processid==getOpenedProcessID() then
    messageDialog('Can not re-enable speedhack on the same process twice', mtError, mbOK)
    return false
  end

  local mataddress=getAddressSafe('libsystem_kernel.dylib.mach_absolute_time')
  if mataddress==nil then
    waitforExports()
    mataddress=getAddressSafe('libsystem_kernel.dylib.mach_absolute_time')

    if (mataddress==nil) then
      reinitializeSymbolhandler()
      if (mataddress==nil) then
        messageDialog('Failure finding libsystem_kernel.dylib.mach_absolute_time', mtError, mbOK)
        return false
      end
    end
  end


  local originalcode,filler=getOriginalCodeAndFiller(mataddress)

--speedhack does not disable. Just sets speed to 1 when done

  local s=string.format([[
alloc(newmem,2048,"libsystem_kernel.dylib")
label(returnhere)
label(originalcode)
label(exit)

{$c}
#include <stddef.h>
uint64_t originalcode(void);
float mat_speed=2.0f; //internal helper for new_mach_absolute_time
uint64_t mat_initialtime=0;
uint64_t mat_initialoffset=0;


float wantedspeed=1.0f; //user changable speed variable


uint64_t new_mach_absolute_time(void)
{
  uint64_t caller=__builtin_return_address(1);
  uint64_t caller2=__builtin_return_address(2);


  uint64_t newtime;

  uint64_t currenttime=originalcode();


  if (mat_initialtime==0)
  {
    mat_initialtime=currenttime;
    mat_initialoffset=currenttime;
  }

  if ((caller<0x7FFF00000000ULL) || (caller2<0x7FFF00000000ULL))
  {
    newtime=(currenttime-mat_initialtime)*mat_speed+mat_initialoffset;
    if (mat_speed!=wantedspeed)
    {
      //the user wants to change the speed
      mat_initialoffset=newtime;
      mat_initialtime=currenttime;
      mat_speed=wantedspeed;
    }
  }
  else
    newtime=currenttime;

  return newtime;

}
{$asm}


newmem: //this is allocated memory, you have read,write,execute access
//place your code here

push rbp
mov rbp,rsp
sub rsp,230

movaps [rsp+30],xmm0
movaps [rsp+40],xmm1
call new_mach_absolute_time
movaps xmm0,[rsp+30]
movaps xmm1,[rsp+40]
add rsp,230
pop rbp
ret

originalcode:
%s

exit:
jmp returnhere

libsystem_kernel.dylib.mach_absolute_time:
jmp newmem
%s

returnhere:

]],originalcode, filler)
  --print(s)
  local result, data=autoAssemble(s)
  if result then
    speedhack={}
    speedhack.processid=getOpenedProcessID()
    speedhack.wantedspeed=data.ccodesymbols.getSymbolFromString('wantedspeed').address
  end

  return result
end

MainForm.cbSpeedhack.OnChange=function(s)
  if s.Checked then
    --print("enabling speedhack")
    local canEnable=(speedhack and speedhack.processid==getOpenedProcessID()) or hookSpeedFunctions()

    if canEnable then
      MainForm.Panel14.Visible=true
      MainForm.btnSetSpeedhack2.OnClick=function(b)
        if speedhack and speedhack.processid==getOpenedProcessID() then
          writeFloat(speedhack.wantedspeed, tonumber(MainForm.editSH2.Text))
        end
      end
    else
      s.Checked=false
    end
  else
    --print("disabling speedhack")
    if speedhack and speedhack.processid==getOpenedProcessHandle() then
      writeFloat(speedhack.wantedspeed, 1)
    end

    MainForm.Panel14.Visible=false
  end
end

